;length of horizontal scan
SCANLENGTH=32;16
ENEMY_COLOR=15;5;9;7

;enemy struct

;enemies states
ENEMY_IDLE=0
ENEMY_LEFT=1
ENEMY_RIGHT=2
ENEMY_DOWN=3
ENEMY_UP=4
ENEMY_FALL=5

MODE_PATROL_X=0
MODE_LADDER=1
MODE_ATTACK=2

resetEnemies:
    ;save current randoms
    ld a,(enemiesList+6) : ld (e1Rnd+1),a
    ld a,(enemiesList+6+16*1) : ld (e2Rnd+1),a
    ld a,(enemiesList+6+16*2) : ld (e3Rnd+1),a

    ld hl,baseEnemies : ld de,enemiesList : ld bc,3*16 : ldir
    ld a, (e1Rnd) : ld (enemiesList+6),a
    ld a, (e2Rnd) : ld (enemiesList+6+16*1),a
    ld a, (e3Rnd) : ld (enemiesList+6+16*2),a

    ld a,0 : ld (spritesTable+4*1+3),a : ld a,192 : ld (spritesTable+4*1),a
    ld a,0 : ld (spritesTable+4*2+3),a : ld a,192 : ld (spritesTable+4*2),a
    ld a,0 : ld (spritesTable+4*3+3),a : ld a,192 : ld (spritesTable+4*3),a
   
    ret

baseEnemies:    
;16 bytes per enemy   
N=0
            dup 3         
            db 0     ;enemy state
            dw 0+256*192 ;pixel coords +1 +2

            db 24*4 ;enemy sprite pointer +3 -frame
            db 24*4 ;enemy sprite pointer +4 -idle direction

            db 0 ;basic animations counter +5
            db N*33 ;rnd pointer +6
            db 32+N*2     ;moveCount +7

            db MODE_PATROL_X ;patrol mode +8
            db FACE_RIGHT            ;face direction +9
            db 0                    ;+10 start DELAY
            db 4+N*16                    ;+11 deadCount
            dw 00000                ;START POSITION +12
            db MODE_PATROL_X                    ;+14 pre patrol Mode
            db 0 ;+15 local delay
N=N+1            
            edup

doEnemies:    
    ld a,(enemyDelay) : inc a : and 1 : ld (enemyDelay),a
    or a
    ret nz

    ld a,(gameState)
    CP GS_GAMEPLAY
    ret nz

    call calcEnemiesSprites

    call doEnemiesMove

    ;enemy blinking while start
    
    ld ix,enemiesList
N=0
    dup 3        
    ;blink sprite if >8 movecount
    ld a,(ix+7+N*16)        
    cp 32
    jr c,1f
    
    ld a,ENEMY_COLOR : ld (spritesTable+(N+1)*4+3),a    
    ld a,(ix+7+N*16)        
    rr a : jr c,1f
    ld a,0 : ld (spritesTable+(N+1)*4+3),a
    jr 2f
1:
    ld a,ENEMY_COLOR : ld (spritesTable+(N+1)*4+3),a 
2:
N=N+1
    edup
    
    ret

teleportEnemy:
    ld (ix+2),15
    ret

//get local random for enemy
getEnemyRandom:
    ld h,high rndX : ld l,(ix+6)
    ld a,(hl)
    inc l
    ld (ix+6),l 
    ret


doEnemiesMove:
    ld ix,enemiesList    
    dup 3
    ld a,(ix+1);if x coord = 0 we outside screen - disable enemy
    or a
    call nz,doOneEnemy
    ld bc,16 : add ix,bc
    edup    
    ret


;sprites 1,2,3
calcEnemiesSprites:
 
    ld ix,enemiesList    
N=0    
    dup 3
    ld a,(ix+1+N*16);get state
    or a
    jr z,1f;skip if disabled

    ;skip if in limbo y=0
    ld a,(ix+2+N*16);get state
    or a
    jr nz,3f;skip if disabled
    ;set y to limbo
    ld a,192 : ld (spritesTable+4*(N+1)),a
    jr 1f  
3:

    ;get coords and put to start
    ld c,(ix+2+N*16) : ld b,(ix+1+N*16)
    ld (spritesTable+4*(N+1)),bc
        
    ;apply a frame by move count
    
    ;get enemy coords and calculate spcreen addr and sprite frame	
	;ld c,(ix+1+N*16) : ld b,(ix+2+N*16) : call getScreenAddr : ld (sprites+2+(N+1)*32),hl
	;in a - delta
	;ld l,a : ld h,0
	;add hl,hl:add hl,hl:add hl,hl:add hl,hl:add hl,hl:add hl,hl
    ;get base enemy sprite and calc frame
    ;ld c,(ix+3+N*16) : ld b,(ix+4+N*16)
	;add hl,bc
	;ld (sprites+(N+1)*32),hl	

    ld a,(ix+3+N*16) : ld (spritesTable+4*(N+1)+2),a

    ;calc basic animations   
    ;delay 
    ld a,(ix+N*16+15) :  inc a : and 3 : ld (ix+N*16+15),a
	or a
	jr nz,1f

    ld a,(ix+5+N*16);get basic counter
    inc a : and 1
    ld (ix+5+N*16),a    
1:

N=N+1
    edup

    ret


;try to select a move dir
doLogic:
    ;save patrol mode to pre patrol mode
    ld a,(ix+8) : ld (ix+14),a

    ;coords to de
    ld e,(ix+1) : ld d,(ix+2)
    call getTile
    cp TILE_TELEPORT
    call z,teleportEnemy


    ld e,(ix+1) : ld d,(ix+2)
    ;get patrol mode
    ld a,(ix+8)

    cp MODE_PATROL_X
    jp z,doXpatrol

    cp MODE_LADDER
    jp z,doLadder

    ret

doLadder:    

    
    ;long ladde fix
    ;check if we at long ladder and there is a land left or right - jump from it
    ;if patrol mode same
    ld a,(ix+8): cp (ix+14)
    jr nz,4f
    ;ok check left or right to move
    call getEnemyRandom
    cp 1
    jr z,1f
    call getEnemyRandom
    or a
    jr z,1f

    ld e,(ix+1) : ld d,(ix+2);coords to de

    ;skip some time this one to move on long ladders
    cp 1
    jr nz,9f    
    call getTile
    dec hl : ld a,(hl)
    cp TILE_SOLID
    jr nc,1f
    ld bc,32 : add hl,bc : 
    ld a,(hl)
    CP TILE_SOLID+1
    jr c,1f
    ld (ix),ENEMY_LEFT : ld (ix+8),MODE_PATROL_X : jp doXpatrol
9:
    call getTile
    inc hl : ld a,(hl)
    cp TILE_SOLID
    jr nc,1f
    ld bc,32 : add hl,bc
    ld a,(hl)
    CP TILE_SOLID+1
    jr c,1f
    ld (ix),ENEMY_RIGHT : ld (ix+8),MODE_PATROL_X : jp doXpatrol
1:


4:
    ld e,(ix+1) : ld d,(ix+2);coords to de
    ;get dir
    ld a,(ix)

    cp ENEMY_UP
    jp z,tryMoveEnemyUp

    cp ENEMY_DOWN
    jp z,tryMoveEnemyDown

    ;set move count
    ld (ix+8),MODE_PATROL_X
    jp doXpatrol
    ret

doFallz:
    ;get tile under enemy
    ;ld bc,32 : add hl,bc: ld a,(hl)	
    ;cp TILE_SOLID+1
    ;ret c
    ld a,ENEMY_FALL : ld (ix),a : jp doXpatrol
    ret

tryMoveEnemyDown:    
 
    call getTile
    cp TILE_LADDER : jr nz,doFallz   

	;cp TILE_LADDER : jr z,1f

    ;get tile under enemy
    ld bc,32 : add hl,bc: ld a,(hl)	

	cp TILE_SOLID :  jr c,1f
	cp TILE_LADDER : jr z,1f
	
    ld (ix),ENEMY_IDLE : ld (ix+8),MODE_PATROL_X : jp doXpatrol
1:
    ;continue moving
    ld a,8
    ret

tryMoveEnemyUp:
    
    call getTile	
    ;get tile aboce enemy
    ld bc,-32 : add hl,bc: ld a,(hl)	
	
	cp TILE_LADDER : jr z,1f
    ld (ix),ENEMY_IDLE : ld (ix+8),MODE_PATROL_X : jp doXpatrol
1:
    ;continue moving
    ld a,8

    ret


doXpatrol:
    ;check if we need fall down then skip player scan
    ld e,(ix+1) : ld d,(ix+2);coords to de    
    call getTile
    ld bc,32:add hl,bc : ld a,(hl)
    cp TILE_LADDER
    jr z,1f
    cp TILE_SOLID
    jp c,000f
1:
	;check Y delta
	ld a,(heroPosition+1)       
    sub (ix+2)        
    add a,4  ;4          
    cp 6;6                
    jp nc,000f             
    ;ok,start scan in face direction
    ;get face direction
    ld a,(ix+9)
    cp FACE_RIGHT
    jr nz,1f
;scan right
    ld e,(ix+1) : ld d,(ix+2);coords to de    
    call getTileCoords
    push hl : pop iy
    ld e,(ix+1)

    ld b,SCANLENGTH
44:
    ld a,(iy+1)
    cp TILE_SOLID+1
    jr nc,000f
    ld a,(iy+32+1)
    cp TILE_LADDER
    jr z,3f
    cp TILE_SOLID
    jr c,000f
3:
    ;ok
    ld a,e : add 8
    ;check enf of screen
    cp 256-16 : jr nc,000f
    ld e,a    

    ld e,a    
    ld a,(heroPosition)
    ;compare with hero x
    sub e    
	add a,3
	cp 6     
    jp nc,2f
    ;ok we found a hero!    
    ;set move dir to right and exit
    ld (ix),ENEMY_RIGHT:ld a,8 : ret
2:
    inc iy
    djnz 44b
    jp 000f

;scan left
1:
    ld e,(ix+1) : ld d,(ix+2);coords to de    
    call getTileCoords
    push hl : pop iy
    ld e,(ix+1); : ld a,e : sub 4 : ld e,a

    ld b,SCANLENGTH
44:
    ld a,(iy-1)
    cp TILE_SOLID+1
    jr nc,000f

    ld a,(iy+32-1)
    cp TILE_LADDER
    jr z,3f
    cp TILE_SOLID   
    jr c,000f
3:
    ;ok
    ld a,e : sub 8
    ;check enf of screen
    or a : jr z,000f
    ld e,a    

    ld a,(heroPosition)
    ;compare with hero x
    sub e    
	add a,3  
	cp 6     
    jp nc,2f
    ;ok we found a hero!    
    ;set move dir to right and exit
    ld (ix),ENEMY_LEFT:ld a,8 : ret
2:
    dec iy
    djnz 44b
    jp 000f

000:

    ld e,(ix+1) : ld d,(ix+2);coords to de    
    ;check falling and bridge builder
    call getTile        
	cp TILE_LADDER : jr z,1f

    ;get tile under enemy
    ld bc,32 : add hl,bc: ld a,(hl)	

    
    ;====================BRIDGE UNDER BLOCK
	cp TILE_LEFT
	jr z,9f
	cp TILE_RIGHT
	jp nz,8f

	ld a,FACE_RIGHT : ld (ttt2),a
	ex af,af :	ld a,TILE_ANTIRIGHT;disable arrow
	ld (hl),a;TILE_ANTILEFT;disable arrow
	ex af,af
	jr 5f
9:
	ld a,FACE_LEFT : ld (ttt2),a
	ex af,af : ld a,TILE_ANTILEFT;disable arrow
	ld (hl),a;TILE_ANTILEFT;disable arrow
	ex af,af
5:	
    ld e,(ix+1) : ld d,(ix+2);coords to de 
	call getTileCoords : inc d : ld bc,32 : add hl,bc
	push de : push hl
	;ex af,af :  call NIRVANA_printC : ex af,af
    ex af,af :  call fillTile : ex af,af

	pop hl : pop de
	
	ld a,(ttt2)
    call initBridge
    ld a,8 : ret
    
	;jp initBridge
    ;========================================
8:
	cp TILE_SOLID :  jr nc,1f
	;cp TILE_LADDER : jr z,1f	
    ;ok, not solid - fall
    ;set fall sprite
    ;set state as fall
    ld (ix),ENEMY_FALL : ld a,4 : ret

1:  
    ;check if we was falling then IDLE
    ld a,(ix)
    cp ENEMY_FALL
    jr nz,3f
    ;IDLE AFTER FALL
    ld (ix),ENEMY_IDLE
    jr 2f

3:
    ;if there was IDLE - set random x dir
    cp ENEMY_IDLE
    jr nz,4f ;continue moving
    ;get next dir random after falling
    call getEnemyRandom
    ld (ix),a
    jr 2f   
4:
    ;ok, we do regular moving


    ;checkLadder and climb
    ld e,(ix+1) : ld d,(ix+2)
    call getTile
    cp TILE_LADDER
    jr nz,6f
    push hl
    call getEnemyRandom
    pop hl
    cp 1
    jr nz,6f

    ;ok - switch to ladder mode
    ld (ix+8),MODE_LADDER

    ;check if up and down lader - long lader here
    ld bc,-32:add hl,bc:ld a,(hl)
    cp TILE_LADDER
    jr nz,1f
    ld bc,64:add hl,bc : ld a,(hl)
    cp TILE_LADDER
    jr nz,1f
    ;ok up down ladders, get random dir
    call getEnemyRandom
    cp 1
    jr nz,3f
    ld (ix),ENEMY_UP
    jp doLadder
3:
    ld (ix),ENEMY_DOWN
    jp doLadder
1:

;=========================================
    ld (ix),ENEMY_UP;set enemy up dir
    ld bc,-32 : add hl,bc; if no ladder above head move move down
    ld a,(hl)
    cp TILE_LADDER
    jr z,7f
    ld (ix),ENEMY_DOWN
    ;jp doLadder
7:      
    jp doLadder
6:


    ;randomly enable idle :)
    call getEnemyRandom        
    ;ok,check if we need a change dir
    or a
    jr nz,2f
    ld (ix),ENEMY_IDLE

    ;contidue moving
2:
    ld a,(ix)
    ld e,(ix+1) : ld d,(ix+2);coords to de


    ;check tile at new position
    cp ENEMY_RIGHT
    jp z,tryMoveEnemyRight
    cp ENEMY_LEFT
    jp z,tryMoveEnemyLeft

    cp ENEMY_IDLE
    jp z,doEnemyIdle

    ;set count to 8
    ld a,8
    ret

doEnemyIdle:
    ld a,32 : ret
    ret

tryMoveEnemyRight:
    ld a,e : add 8 : ld e,a
    call getTile	
    cp TILE_SOLID+1
    jp nc,switchHDir

    ;check what under legs
    ld bc,32 : add hl,bc : ld a,(hl)
    cp TILE_LADDER
    jr z,1f
    cp TILE_SOLID+1
    jr c,tryToFall
1:
    ;set move count
	ld a,8
    ret

tryMoveEnemyLeft:
    ld a,e : sub 8+4 : ld e,a
    call getTile	
    cp TILE_SOLID+1
    jp nc,switchHDir

    ;check what under legs
    ld bc,32 : add hl,bc : ld a,(hl)
    cp TILE_LADDER
    jr z,1f
    cp TILE_SOLID+1
    jr c,tryToFall
1:
    ;set move count
	ld a,8
    ret

;decide to fall from a edge or switch a dir
tryToFall:
    call getEnemyRandom
    ;or a
    cp 2
    ld a,8
    ret z
    ;call getEnemyRandom
    ;cp 1
    ;ld a,8
    ;ret z

switchHDir:
    ld a,(ix)
    CP ENEMY_RIGHT
    jr nz,1f
    ld (ix),ENEMY_LEFT
    ;check if we in a hole
    dec hl : ld a,(hl)
    cp TILE_SOLID+1
    jr nc,4f
    ld (ix),ENEMY_IDLE
4:
    ld a,8
    ret  
1:
    ld (ix),ENEMY_RIGHT
    ;check if we in a hole
    inc hl : ld a,(hl)
    cp TILE_SOLID+1
    jr nc,4f
    ld (ix),ENEMY_IDLE
4:
    ld a,8
    ret

killEnemy:
    ;set dead count
    ld a,128 : ld (ix+11),a
    ;ld a,12 : call AFXPLAY3  
    di : ld a,12 : ld c,0 : call ayFX_INIT : ei;15-low 0 -high
    ret

hideEnemy:
    ;move to limbo
    ld (ix+2),0
    di : ld a,10 : ld c,0 : call ayFX_INIT : ei;15-low 0 -high
    ;ld a,10 : call AFXPLAY3
    ret
doEnemyDead:
    dec a
    ld (ix+11),a
    cp 128-32
    jr z,hideEnemy
    ld a,(ix+11)
    or a    
    ret nz
;
    ld a,(ix+7)
    ;not to kill enemy frame logic smashing just add to current move count
    add 64    
    ld (ix+7),a

    ld (ix),ENEMY_IDLE
    ;move to start point
    ld a,(ix+12) : ld (ix+1),a
    ld a,(ix+13) : ld (ix+2),a
    ;ld a,11 : call AFXPLAY3
    di : ld a,11 : ld c,0 : call ayFX_INIT : ei;15-low 0 -high
    ret

;ix - enemy pointer
doOneEnemy:
    ;check if we not dead then check for dead
    ld a,(ix+11)
    or a
    jr nz,doEnemyDead

    ;ok we live
    ;check dead on fire and spikes
    ld e,(ix+1) : ld d,(ix+2);coords to de
    ;ld a,d : add 4 : ld d,a
    call getTile
    cp TILE_FIRE
    jp z,killEnemy
    cp TILE_PIKE
    jp z,killEnemy


1:

    ;check if moveCount = 0 then try to select a move dir
    ;else we move

    ld a,(ix+7)
    or a
    call z,doLogic
    ;else move
    dec a
    ld (ix+7),a
    

    ;ld e,(ix+1) : ld d,(ix+2);coords to de
    ;get state
    ld a,(ix)
    cp ENEMY_RIGHT
    jp z,moveEnemyRight
    cp ENEMY_LEFT
    jp z,moveEnemyLeft
    cp ENEMY_FALL
    jp z,fallEnemy

    cp ENEMY_DOWN
    jp z,downEnemy

    cp ENEMY_UP
    jp z,upEnemy

    cp ENEMY_IDLE
    jp z,idleEnemy

    ret

downEnemy:
    ;ld hl,enemyLadder : ld b,0 : ld c,(ix+5): add hl,bc
;    ld (ix+3),l : ld (ix+4),h
    ld c,(24+4)*4 
    ld a,(ix+5)
    add a,a : add a,a
    add c
    ld (ix+3),a
;move down
    inc (ix+2)
    ret

upEnemy:
    ;ld hl,enemyLadder : ld b,0 : ld c,(ix+5): add hl,bc
 ;   ld (ix+3),l : ld (ix+4),h

    ld c,(24+4)*4 
    ld a,(ix+5)
    add a,a : add a,a
    add c
    ld (ix+3),a

;move down
    dec (ix+2)
    ret

fallEnemy:
;update sprites    
    ;ld hl,enemyFall : ld b,0 : ld c,(ix+5): add hl,bc
    ;ld (ix+3),l : ld (ix+4),h
    ld c,(24+6)*4 
    ld a,(ix+5)
    add a,a : add a,a
    add c
    ld (ix+3),a

;move down
    inc (ix+2)
    inc (ix+2)
    ret

idleEnemy:
     ld c,(ix+4) ; idle direction
     ld a,(ix+5) : add a,a : add a,a : add c
     ld (ix+3),a
;    ld hl,enemyIdle: ld b,0 : ld c,(ix+5): add hl,bc  
;    ld (ix+3),l : ld (ix+4),h
    ret

moveEnemyRight: 
    ;patch idle
    ;ld hl,enemyIdle : ld (idleEnemy),hl
    ld (ix+4),24*4
    ;save face position
    ld (ix+9),FACE_RIGHT

 ;   ld hl,enemyRight
 ;   ld (ix+3),l : ld (ix+4),h
     
    ;ld a,(24+16)*4 : ld (ix+3),a

    ;ld (ix+3),(24+16)*4

    ld c,(24+16)*4 
    ld a,(ix+7)
    add a,a : add a,a
    add c
    ld (ix+3),a

    inc (ix+1);x coords
    ret

moveEnemyLeft:    
    ld (ix+4),26*4
    ;patch idle
    ;ld hl,enemyIdle+128 : ld (idleEnemy),hl
    ;save face position
    ld (ix+9),FACE_LEFT

 ;   ld hl,enemyLeft
  ;  ld (ix+3),l : ld (ix+4),h
    
    ;ld (ix+3),(24+8)*4

    ld c,(24+8)*4 
    ld a,(ix+7)
    add a,a : add a,a
    add c
    ld (ix+3),a
    
    dec (ix+1);x coords
    ret



    align 256
rndX: incbin "include\rndX.bin"